//=============================================================================
// Photons for constructing ammo.
//=============================================================================
class Photons extends Pickup
	abstract;

#exec OBJ LOAD FILE=MarkistanEffects

var() travel int PhotonAmount;
var() travel int MaxPhotons;
var() class<photons> ParentPhotons; 
var() byte UsedInWeaponSlot[10];
var   photons pphotons;



// Network replication
//
replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner )
		PhotonAmount;
}

event float BotDesireability(Pawn Bot)
{
	local Photons AlreadyHas;

	if ( ParentPhotons != None )
		AlreadyHas = Photons(Bot.FindInventoryType(ParentPhotons));
	else
		AlreadyHas = Photons(Bot.FindInventoryType(Class));
	if ( AlreadyHas == None )
		return (0.35 * MaxDesireability);
	if ( AlreadyHas.PhotonAmount == 0 )
		return MaxDesireability;
	if (AlreadyHas.PhotonAmount >= AlreadyHas.MaxPhotons) 
		return -1;

	return ( MaxDesireability * FMin(1, 0.15 * MaxPhotons/AlreadyHas.PhotonAmount) );
}

function bool HandlePickupQuery( inventory Item )
{
	if ( (class == item.class) || 
		(ClassIsChildOf(item.class, class'Markistan.Photons') && (class == Photons(item).parentphotons)) ) 
	{
		if (PhotonAmount==MaxPhotons) return true;
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if (Item.PickupMessageClass == None)
			// DEUS_EX CNN - use the itemArticle and itemName
//			Pawn(Owner).ClientMessage( Item.PickupMessage, 'Pickup' );
			Pawn(Owner).ClientMessage( Item.PickupMessage @ Item.itemArticle @ Item.ItemName, 'Pickup' );
		else
			Pawn(Owner).ReceiveLocalizedMessage( Item.PickupMessageClass, 0, None, None, item.Class );
		item.PlaySound( item.PickupSound );
		AddPhotons(Photons(item).PhotonAmount);
		item.SetRespawn();
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

simulated function bool SimUsePhotons();

// This function is called by an actor that wants to use photons.  
// Return true if photon exists 
//
function bool UsePhotons(int AmountNeeded)
{
	if (PhotonAmount < AmountNeeded) return False;   // Can't do it
	PhotonAmount -= AmountNeeded;
	return True;
}

// If we can, add photons and return true.  
// We we are at max photons, return false
//
function bool AddPhotons(int PhotonsToAdd)
{
	If (PhotonAmount >= MaxPhotons) return false;
	PhotonAmount += PhotonsToAdd;
	if (PhotonAmount > MaxPhotons) PhotonAmount = MaxPhotons;
	return true;
}

function inventory SpawnCopy( Pawn Other )
{
	local Inventory Copy;

	if ( parentphotons != None )
	{
		Copy = spawn(parentphotons,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;
		Copy.Instigator    = Other;
		Photons(Copy).PhotonAmount = PhotonAmount;
		Copy.BecomeItem();
		Other.AddInventory( Copy );
		Copy.GotoState('');
		if ( Level.Game.ShouldRespawn(self) )
			GotoState('Sleeping');
		else
			Destroy();
		return Copy;
	}
	Copy = Super.SpawnCopy(Other);
	Photons(Copy).PhotonAmount = PhotonAmount; 
	return Copy;
}

defaultproperties
{
     PickupMessage="Obtain photons!"
     RespawnTime=23.000000
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.SphereEffect'
     PlayerViewScale=0.125000
     PickupViewMesh=LodMesh'DeusExItems.SphereEffect'
     PickupViewScale=0.125000
     ThirdPersonMesh=LodMesh'DeusExItems.SphereEffect'
     ThirdPersonScale=0.125000
     MaxDesireability=0.200000
     LandSound=Sound'DeusExSounds.Generic.PlasticHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconCredits'
     beltDescription="Photons"
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'MarkistanEffects.Energy.PhotonTex'
     Skin=FireTexture'MarkistanEffects.Energy.PhotonTex'
     Mesh=LodMesh'DeusExItems.SphereEffect'
     DrawScale=0.250000
     CollisionRadius=4.000000
     CollisionHeight=3.750000
     bCollideActors=False
     Mass=2.000000
     Buoyancy=3.000000
}
